function ParamSpace
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%            MBI Bootcamp in Cancer Modeling           %%
%% Mathematical Biosciences Institute, Sept. 7-10, 2010 %%
%% K.A. Rejniak, Moffitt Cancer Center & Research Inst. %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


disp(' _____________________________________________________________');
disp('|                                                             |');
disp('| This routine  will construct  a 3D model  parameter  space  |');
disp('| divided into 4 color-coded classes based on the tumor size. |');
disp('| All data for a 3x3x2 matrix will be specified  by the user. |');
disp('|_____________________________________________________________|');
disp(' ');
disp(' ');


data=zeros(3,3,2);
for jj=1:3  %% probability
 for ii=1:2  %% speed
   for kk=1:3  %% doubling time
     iii=2*ii-1;
     jjj=5+45*(jj-1);
     kkk=6+12*(kk-1);
     aa=input(['value for movement probability: ',num2str(jjj),...
       '%; speed: ',num2str(iii),'; doub. time: ',num2str(kkk),' =']);
     data(jj,kk,ii)=aa; 
   end
 end
end

%data(1:3,1:3,1)=[ 9989,3449,1273; 9678, 6449, 4920;717,11,136]; 
%data(1:3,1:3,2)=[12575,5498,2459;24075,22717,13928;129,44,129]; 


mm=max(max(max((data))));
dm=round((mm-1000)/3);

figure
axis([-5,160,-5,60,-1,3])
grid
hold on

title(['yellow:<1000;  red:[1000,',num2str(dm),'];  blue:[',num2str(dm),...
    ',',num2str(2*dm),'];  green:>',num2str(2*dm),' cells'],'FontSize',13)

xlabel('probability','FontSize',15);
ylabel('doubling time [h]','FontSize',15);
zlabel('cell speed','FontSize',15);



for jj=1:3
  for kk=1:3
    for ii=1:2
      if data(kk,jj,ii)<1000
        col='y';  
      elseif data(kk,jj,ii)<dm
        col='r';  
      elseif data(kk,jj,ii)<2*dm
        col='b';  
      else
        col='g';  
      end
      
      patch(5+45*[jj-1,jj-1,jj,jj,jj-1],6+12*[kk-1,kk-1,kk-1,kk-1,kk-1],[ii-1,ii,ii,ii-1,ii-1],col)
      patch(5+45*[jj-1,jj-1,jj,jj,jj-1],6+12*[kk,kk,kk,kk,kk],[ii-1,ii,ii,ii-1,ii-1],col)
      patch(5+45*[jj-1,jj,jj,jj-1,jj-1],6+12*[kk-1,kk-1,kk,kk,kk-1],[ii-1,ii-1,ii-1,ii-1,ii-1],col)
      patch(5+45*[jj-1,jj,jj,jj-1,jj-1],6+12*[kk-1,kk-1,kk,kk,kk-1],[ii,ii,ii,ii,ii],col)
      patch(5+45*[jj-1,jj-1,jj-1,jj-1,jj-1],6+12*[kk-1,kk-1,kk,kk,kk-1],[ii-1,ii,ii,ii-1,ii-1],col)
      patch(5+45*[jj,jj,jj,jj,jj],6+12*[kk-1,kk-1,kk,kk,kk-1],[ii-1,ii,ii,ii-1,ii-1],col)
      
      pause(0.25)
      
    end
  end 
end
alpha(0.5)
view(3)


 for ii=1:40 
    view(-37.5+5*ii,30); 
    pause(0.25); 
 end




end