function AllInOne
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%            MBI Bootcamp in Cancer Modeling           %%
%% Mathematical Biosciences Institute, Sept. 7-10, 2010 %%
%% K.A. Rejniak, Moffitt Cancer Center & Research Inst. %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


disp(' __________________________________________________________________');
disp('|                                                                  |');
disp('| This simulations will show development of  a 2D cluster of tumor |');
disp('| cells that can either  grow or migrate towards  higher levels of |');
disp('| nutrients with 6 clones of mutated cells arising during the run  |');
disp('|__________________________________________________________________|');
disp(' ');
disp(' ');
pause(0.1)



%% cell diam=10 microns; domain=550cells=5mm
%% base doubling time=6h;  
DomNum= 500;        % number of sites in each direction; #cells
%IterNum=125;        % number of iterations      

domain=zeros(DomNum,DomNum,2); % domain: [tumor loction, nutrients]
tumor=zeros(DomNum*DomNum,5);  % tumor cells: [x,y,age,state,clone]
% state: 0=viable 1=quiscent  2=necrotic
% clone: 0=base line 1-6: clone number
DivSid=[-1,0;1,0;0,-1;0,1]; % 4 dir for cell division  
DivDir=4;
MovSid=[-1,-1;-1,0;-1,1;0,-1;0,1;1,-1;1,0;1,1]; % 8 div for cell move
MovDir=8;                             

CloneInit=1000;
CloneNumber=6;


IterNum=DefineFinalTime;

disp(' define parameters for the base line:');
DoTi1=DefineDoublingTime;
MoSp1=DefineMovementSpeed;
MoPr1=DefineMovementProbability;
GrTh1=DefineGrowthThreshold;
DeTh1=DefineDeathThreshold;


disp(' define parameters for the mutants:');
DoTi2=DefineDoublingTime;
MoSp2=DefineMovementSpeed;
MoPr2=DefineMovementProbability;
GrTh2=DefineGrowthThreshold;
DeTh2=DefineDeathThreshold;


DoubTime= [DoTi1,DoTi2];
MoveSped= [MoSp1,MoSp2];
MoveProb= [MoPr1,MoPr2];

GrowThr=[GrTh1,GrTh2];
DeadThr=[DeTh1,DeTh2];
EatThr= 5;


Ntumor=1;                                % current number of tumor cells
tumor(Ntumor,1:3)=[DomNum/2,DomNum/2,1]; % first cell in the middle
domain(DomNum/2,DomNum/2,1)=1;           % middle site is filled  



domain=DiffuseFromChoice(domain,DomNum,2,MovSid);
DrawAll(domain,DomNum,tumor,Ntumor,0,IterNum,GrowThr,DeadThr)



%% iterations %%
disp([' ... 2D tumor cluster is growing ... final time: ',num2str(IterNum*6),' hrs']);
for Niter=1:IterNum
  tumor(:,3)=tumor(:,3)+1;                   % increase cell age
  
  
  domain=Uptake(domain,DomNum,2,EatThr);  % decrease nutrients at cell locations
  
  
  for jj=1:Ntumor              % inspect all tumor cells

    Clind=tumor(jj,5);              % cloned?
    DThr=DeadThr(min(2,1+Clind));
    GThr=GrowThr(min(2,1+Clind));
    MProb=MoveProb(min(2,1+Clind));
  
            
    if (domain(tumor(jj,1),tumor(jj,2),2)<DThr)
      tumor(jj,4)=2;  
    elseif (domain(tumor(jj,1),tumor(jj,2),2)<GThr)
      tumor(jj,4)=1;  
    else
      tumor(jj,4)=0;  
    end
    
    chance=randi(100);    % probability
      
     if (chance<MProb)  %% cell is moving if there is a space
      tumxy=[tumor(jj,1),tumor(jj,2)]; 
      MSped=MoveSped(min(2,1+Clind));
      Mchoise=zeros(MovDir,2);
      kch=0;
      for kk=1:MovDir 
        movxy=MSped*[MovSid(kk,1),MovSid(kk,2)];  
        if ((tumxy(1)+movxy(1)>0)&&(tumxy(1)+movxy(1)<=DomNum)&&...
          (tumxy(2)+movxy(2)>0)&&(tumxy(2)+movxy(2)<=DomNum))           
          if (domain(tumxy(1)+movxy(1),tumxy(2)+movxy(2),1)==0)
            kch=kch+1;
            Mchoice(kch,1)=kk;
            Mchoice(kch,2)=domain(tumxy(1)+movxy(1),tumxy(2)+movxy(2),2);
          end
        end
      end   
      if (kch>1)
        val=max(Mchoice(1:kch,2));
        Ind=find(Mchoice(1:kch,2)==val);
        szI=size(Ind,1);
        which=randi(szI);
      
        domain(tumxy(1),tumxy(2),1)=0;
        movxy=MSped*[MovSid(Mchoice(Ind(which)),1),MovSid(Mchoice(Ind(which)),2)]; 
        tumor(jj,1)=tumxy(1)+movxy(1); % new cell coordinates 
        tumor(jj,2)=tumxy(2)+movxy(2);
        domain(tumxy(1)+movxy(1),tumxy(2)+movxy(2),1)=1; % fill a domain site
      end
    else   % cell is growing if there is a space   
      DTime=DoubTime(min(2,1+Clind));    
      if ((tumor(jj,3)>=DTime)&&(tumor(jj,4)==0)) % cell must be mature to divide 
        tumxy=[tumor(jj,1),tumor(jj,2)];
        tumcl=tumor(jj,5);
        Dchoice=zeros(DivDir,2); 
        kch=0;
        for kk=1:DivDir  
          if ((tumxy(1)+DivSid(kk,1)>0)&&(tumxy(1)+DivSid(kk,1)<=DomNum)...
            &&(tumxy(2)+DivSid(kk,2)>0)&&(tumxy(2)+DivSid(kk,2)<=DomNum))  
            if (domain(tumxy(1)+DivSid(kk,1),tumxy(2)+DivSid(kk,2),1)==0)
              kch=kch+1;
              Dchoice(kch,1)=kk;
              Dchoice(kch,2)=domain(tumxy(1)+DivSid(kk,1),tumxy(2)+DivSid(kk,2),2);
            end
          end
        end
        if (kch>1)
          tumor(jj,3)=0;         % mother cell become a doughter cell  
                   
          which=randi(kch);
%           val=max(Dchoice(1:kch,2));
%           Ind=find(Dchoice(1:kch,2)==val);  
%           szI=size(Ind,1);  
%           which=randi(szI);
%          %[2,which,val]  
          
          Ntumor=Ntumor+1;           % add a new tumor cell
          tumor(Ntumor,1)=tumxy(1)+DivSid(Dchoice(which),1); % new cell  
          tumor(Ntumor,2)=tumxy(2)+DivSid(Dchoice(which),2); % coordinates 
          tumor(Ntumor,3)=0;
          tumor(Ntumor,5)=tumcl;
          domain(tumxy(1)+DivSid(Dchoice(which),1),tumxy(2)+... % fill a domain site
            DivSid(Dchoice(which),2),1)=1;
        
          Clmax=max(tumor(1:Ntumor,5));
          if ((Ntumor>CloneInit)&&(tumcl==0)&&(Clmax<CloneNumber))
            tumor(Ntumor,5)=Clmax+1;  
          end

        end
      end
    end
  end
    
  % draw a new cell
  if (mod(Niter,3)==0)
    DrawAll(domain,DomNum,tumor,Ntumor,Niter,IterNum,GrowThr,DeadThr)  
  end
end

DrawAll(domain,DomNum,tumor,Ntumor,Niter,IterNum,GrowThr,DeadThr)


%%% number of viable, quiescent and necrotic cells;
  tumState=tumor(1:Ntumor,4);
  Ind=find(tumState==0);
  NumViab=size(Ind,1);
  Ind=find(tumState==1);
  NumQuie=size(Ind,1);
  Ind=find(tumState==2);
  NumNecr=size(Ind,1);

%%% number of cells in each clone;
  CloneIle=zeros(CloneNumber,1);   
  tumClone=tumor(1:Ntumor,5);
  for ii=1:CloneNumber
    Ind=find(tumClone==ii);
    CloneIle(ii,1)=size(Ind,1);    
  end

colClone=['g','b','r','y','m','c'];
disp( ' ______________________________________________________________');
disp( '|                                                              |');
disp(['   This tumor cluster contains ',num2str(Ntumor),' cells ']);
disp(['   viable: ',num2str(NumViab),'; quiescent: ',num2str(NumQuie),'; necrotic: ',num2str(NumNecr)]);
disp( ' ');
for ii=1:CloneNumber
disp(['   Cluster ',num2str(ii),'~',colClone(ii),' contains ',num2str(CloneIle(ii,1)),' cells']);
end
disp( ' ');
disp( '   data shown for base tumor & all clones:')
disp(['   Tumor cell doubling time: [',num2str(DoubTime*6),'] hour(s)']);
disp(['   Tumor cell motility speed level: [',num2str(MoveSped),']x 1.5 microns per sec']);
disp(['   Tumor cell motility probability: [',num2str(MoveProb),']%']);
disp(['   Tumor growth nutrient threshold: [',num2str(GrowThr),']']);
disp(['   Tumor death nutrient threshold:  [',num2str(DeadThr),']']);
disp(['   Tumor cell nutrient uptake: ',num2str(EatThr)]);
disp( '|______________________________________________________________|');
disp( ' ');
disp( ' ');

  
nn=randi(150);
fname=['Ex5_',num2str(nn)];
print('-djpeg100',fname)

%fname=['tumGM_',num2str(DoubTime*6),'h_',num2str(MoveSped),'sp_',num2str(floor(MoveProb)),'perc.txt'];
%tumTosave=tumor(1:Ntumor,1:4);
%save(fname,'tumTosave','-ASCII')


disp(' ');
disp('The End!');
disp(' ');
clear all

end


%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineFinalTime
  cond=1;
  while (cond>0)
    dt=input('choose time of tumor growth (typically it is 600 hours): ');
    %%% unit is 10 micron per 6 hours, i.e., 0.25x10^-5 mm/min
    if (dt>=0) cond=0; end
  end
  outVal=round(dt/6)
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineGrowthThreshold
  cond=1;
  while (cond>0)
    dt=input('choose growth threshold between 10 and 300: ');
    if ((dt>=10)&&(dt<=300)) cond=0; end
  end
  outVal=dt;
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineDeathThreshold
  cond=1;
  while (cond>0)
    dt=input('choose death threshold between 5 and 100: ');
    if ((dt>=5)&&(dt<=100)) cond=0; end
  end
  outVal=dt;
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineUptakeThreshold
  cond=1;
  while (cond>0)
    dt=input('choose uptake threshold between 5 and 50: ');
    if ((dt>=5)&&(dt<=50)) cond=0; end
  end
  outVal=dt;
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineDoublingTime
  cond=1;
  while (cond>0)
    dt=input('choose doubling time between 6 and 36 hours: ');
    if ((dt>=6)&&(dt<=36)) cond=0; end
  end
  outVal=dt/6;
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineMovementSpeed
  cond=1;
  while (cond>0)
    dt=input('choose movement speed: 1, 2 or 3 (x1.5 microns per h): ');
    %%% unit is 10 micron per 6 hours, i.e., 0.25x10^-5 mm/min
    if ((dt>=1)&&(dt<=3)) cond=0; end
  end
  outVal=round(dt);
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineMovementProbability
  cond=1;
  while (cond>0)
    dt=input('choose probabilty [0..100] of cell migration over cell grow: ');
    if ((dt>=0)&&(dt<=100)) cond=0; end
  end
  outVal=dt;
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DiffuseFromBoundary(domain,DomNum,ind,DivSid);
  domain(1:DomNum,     1,2)=(DomNum+15)*ones(DomNum,1);
  domain(1:DomNum,DomNum,2)=(DomNum+15)*ones(DomNum,1);
  domain(     1,1:DomNum,2)=(DomNum+15)*ones(1,DomNum);
  domain(DomNum,1:DomNum,2)=(DomNum+15)*ones(1,DomNum);
  domain2=domain;
  
  szI=size(DivSid,1);
  neigb=zeros(szI,1);
  
   for ii=2:DomNum-1
     for jj=2:DomNum-1
       for ll=1:szI
         neigb(ll)=domain(ii+DivSid(ll,1),jj+DivSid(ll,2),ind);
       end
       domain(ii,jj,ind)=max(neigb)-1;  
     end
   end  
      
   for ii=DomNum-1:-1:2
     for jj=2:DomNum-1
       for ll=1:szI
         neigb(ll)=domain2(ii+DivSid(ll,1),jj+DivSid(ll,2),ind);
       end
       domain2(ii,jj,ind)=max(neigb)-1;  
     end
   end  
   

   for ii=1:DomNum
     for jj=1:DomNum
       domain(ii,jj,2)=max(domain(ii,jj,2),domain2(ii,jj,2));   
     end
   end
        
  outVal=domain;
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=DiffuseFromChoice(domain,DomNum,ind,DivSid);
  domain(1:DomNum,     1,ind)=5*ones(DomNum,1);
  domain(1:DomNum,DomNum,ind)=5*ones(DomNum,1);
  domain(     1,1:DomNum,ind)=5*ones(1,DomNum);
  domain(DomNum,1:DomNum,ind)=5*ones(1,DomNum);
 
 
  scrz=get(0,'ScreenSize');
  figure('Position',[10,scrz(4)/3,2*scrz(3)/3,2*scrz(4)/3])
 
  p1=subplot('Position',[0.0,0.2,0.75,0.75]);
  axis([0,DomNum+1,0,DomNum+1])
  hold on
  axis equal
  axis([0,DomNum+1,0,DomNum+1])
  grid
  
  disp( '  ')
  disp( '  ')
  disp([' choose 3 locations for the sources of nutrients (veins) inside the domain'])
  disp( ' move kursor over the desired source position  and press a mouse button to')
  disp( ' mark it.')
  disp( ' ')

  for ii=1:3
    [x,y]=ginput(1);
    xpos(ii,1)=x; xpos(ii,2)=y;
    text(xpos(ii,1),xpos(ii,2),'o');
    domain(floor(x),floor(y),ind)=DomNum+15;;
    title(['you have already placed ',num2str(ii),' points out of 3']);
  end
  disp(' ... calculating ...');
  pause(0.1)

  
%     domain( 50,100,ind)=DomNum+15;;
%     domain(100, 50,ind)=DomNum+15;;
%     domain(300,300,ind)=DomNum+15;;
 
  
   
  szI=size(DivSid,1);
  neigb=zeros(szI,1);
  
  domain1=domain;
  domain2=domain;
  domain3=domain;
  
  
   for ii=2:DomNum-1
     for jj=2:DomNum-1
       for ll=1:szI
         neigb(ll)=domain(ii+DivSid(ll,1),jj+DivSid(ll,2),ind);
       end
       domain(ii,jj,ind)=max(neigb)-1;  
     end
   end
   
   for ii=DomNum-1:-1:2
     for jj=2:DomNum-1
       for ll=1:szI
         neigb(ll)=domain1(ii+DivSid(ll,1),jj+DivSid(ll,2),ind);
       end
       domain1(ii,jj,ind)=max(neigb)-1;  
     end
   end  

   for ii=DomNum-1:-1:2
     for jj=DomNum-1:-1:2
       for ll=1:szI
         neigb(ll)=domain2(ii+DivSid(ll,1),jj+DivSid(ll,2),ind);
       end
       domain2(ii,jj,ind)=max(neigb)-1;  
     end
   end  

   for ii=2:DomNum-1
     for jj=DomNum-1:-1:2
       for ll=1:szI
         neigb(ll)=domain3(ii+DivSid(ll,1),jj+DivSid(ll,2),ind);
       end
       domain3(ii,jj,ind)=max(neigb)-1;  
     end
   end  
  
   
   for ii=1:DomNum
     for jj=1:DomNum
       domain(ii,jj,ind)=max(domain(ii,jj,ind),domain1(ii,jj,ind));
       domain(ii,jj,ind)=max(domain(ii,jj,ind),domain2(ii,jj,ind));
       domain(ii,jj,ind)=max(domain(ii,jj,ind),domain3(ii,jj,ind));   
     end
   end
     
  
   %% smoothing
    for ij=1:5 
     domain1=domain;
     alpha=0.5;
     for ii=2:DomNum-1
       for jj=2:DomNum-1
         domain(ii,jj,ind)=domain1(ii,jj,ind)+alpha*(domain1(ii-1,jj,ind)+...
         domain1(ii,jj-1,ind)+domain1(ii+1,jj,ind)+domain1(ii,jj+1,ind)-...
         4*domain1(ii,jj,ind));   
       end
     end
    end
   
   outVal=domain;
end

%%%%%%%%%%%%%%%%%%%%%%
function outVal=Uptake(domain,DomNum,ind,EatThr);

  domain2=domain;
  for ii=1:DomNum
    for jj=1:DomNum
      if (domain(ii,jj,1)>0)
        domain(ii,jj,ind)=max(0,domain(ii,jj,ind)-EatThr);
      end
    end
  end
 
  outVal=domain;
end

%%%%%%%%%%%%%%%%%%%%%%
function DrawAll(domain,DomNum,TumVect,TumNum,iter,IterNum,GrowThr,DeadThr)

  clf
    
  p1=subplot('Position',[0.0,0.4,0.5,0.5]);
  axis([0,DomNum+1,0,DomNum+1])
  hold on
  axis equal
  axis([0,DomNum+1,0,DomNum+1])

  [xg,yg]=meshgrid(1:1:DomNum,1:1:DomNum);  
  surf(yg,xg,domain(:,:,2))
  view(2)
  shading interp   
  maxNut=max(max(domain(:,:,2)));
  caxis([0,maxNut])
  colorbar
  title(['max nutrients: ',num2str(maxNut),';  time: ',num2str(6*iter)]); 
  
  
  p2=subplot('Position',[0.5,0.1,0.5,0.5]);
  axis([0,DomNum+1,0,DomNum+1])
  hold on
  axis equal
  axis([0,DomNum+1,0,DomNum+1])
 
  
  Acol=['g','r','k'];
  Anum=3;
  tumState=TumVect(1:TumNum,4);
  for kk=0:Anum-1
    Ind=find(tumState==kk);
    sInd=size(Ind,1);
    plot(TumVect(Ind(1:sInd),1),TumVect(Ind(1:sInd),2),'o',...
         'MarkerEdgeColor',Acol(kk+1),'MarkerFaceColor',Acol(kk+1)) 
  end
  
  
  
  Ccol=['g','b','r','y','m','c','k'];
  Cnum=6;
  tumClone=TumVect(1:TumNum,5);
  for kk=1:Cnum
    Ind=find(tumClone==kk);
    sInd=size(Ind,1);
    plot(TumVect(Ind(1:sInd),1),TumVect(Ind(1:sInd),2),'*',...
      'MarkerEdgeColor',Ccol(kk+1),'MarkerSize',7) 
  end

  
  text(10,10,'cells: ','FontSize',11)
  Axpos=[100,200,300];
  text(50,10,'viable')
  text(130,10,'qiescent')
  text(230,10,'necrotic')
  for ii=1:Anum
    plot(Axpos(ii),10,'ko','MarkerFaceColor',Acol(ii),'MarkerSize',7)
    hold on
  end
  title(['the mutated tumor cells are indicated by stars; total number of cells: ',num2str(TumNum)])
  pause(0.1)

end

%%%%%%%%%%%%%%%%%%%%%%

