function TumorGrowth
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%            MBI Bootcamp in Cancer Modeling           %%
%% Mathematical Biosciences Institute, Sept. 7-10, 2010 %%
%% K.A. Rejniak, Moffitt Cancer Center & Research Inst. %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


disp(' ___________________________________________________');
disp('|                                                   |');
disp('| This simulations will show growth of a 2D cluster |');
disp('| of tumor cells with a cell doubling time  defined |');
disp('| by the user.                                      |');
disp('|___________________________________________________|');
disp(' ');
disp(' ');



%% cell diam=10 microns; domain=200cells=2mm
%% base doubling time=6h;  
DomNum=200;          % number of sites in each direction; #cells
IterNum=100;         % number of iterations      

domain=zeros(DomNum,DomNum);    % 3D empty domain
tumor=zeros(DomNum*DomNum,3);   % tumor cells: [x,y,age]
DivSid=[-1,0;1,0;0,-1;0,1];     % 4 dir for cell division  
DivDir=4;

DoubTime=DefineDoublingTime;

Ntumor=1;                                % current number of tumor cells
tumor(Ntumor,1:3)=[DomNum/2,DomNum/2,1]; % first cell in the middle
domain(DomNum/2,DomNum/2)=1;             % middle site is filled  


DrawTumorAge(tumor,Ntumor,DomNum,0,IterNum)


%% iterations %%
disp([' ... 2D tumor cluster is growing ... final time: ',num2str(IterNum*6),' hrs']);
for Niter=1:IterNum
  tumor(:,3)=tumor(:,3)+1;     % increase cell age
  for jj=1:Ntumor              % inspect all tumor cells
      
    if (tumor(jj,3)>=DoubTime) % cell must be mature to divide 
      tumxy=[tumor(jj,1),tumor(jj,2)];     
      choice=zeros(DivDir,1);
      kch=0;
      for kk=1:DivDir  
        if ((tumxy(1)+DivSid(kk,1)>0)&&(tumxy(1)+DivSid(kk,1)<=DomNum)&&...
            (tumxy(2)+DivSid(kk,2)>0)&&(tumxy(2)+DivSid(kk,2)<=DomNum))  
          if (domain(tumxy(1)+DivSid(kk,1),tumxy(2)+DivSid(kk,2))==0)
            kch=kch+1;
            choice(kch)=kk;
          end
        end
      end
      if (kch>1)
        tumor(jj,3)=0;         % mother cell become a doughter cell    
          
        which=randi(kch);
        Ntumor=Ntumor+1;           % add a new tumor cell
        tumor(Ntumor,1)=tumxy(1)+DivSid(choice(which),1); % new cell  
        tumor(Ntumor,2)=tumxy(2)+DivSid(choice(which),2); % coordinates 
        tumor(Ntumor,3)=0;
        domain(tumxy(1)+DivSid(choice(which),1),tumxy(2)+... % fill a domain site
          DivSid(choice(which),2))=1; 
      end
    end
  end
  
  % draw a new cell
  if (mod(Niter,5)==0)
    DrawTumorAge(tumor,Ntumor,DomNum,Niter,IterNum)
  end
end

%%% max spread of tumor cells
dist=0;
for l1=1:Ntumor
  distX=max(sqrt((tumor(1:Ntumor,1)-tumor(l1,1)).^2+...
  (tumor(1:Ntumor,2)-tumor(l1,2)).^2));  
  dist=max(dist,distX); 
end


disp( ' ___________________________________________________');
disp( '|                                                   |');
disp(['   This tumor cluster contains ',num2str(Ntumor),' cells ']);
disp(['   Cluster diameter (max) ',num2str(10*dist),' microns ']);
disp( ' ');
disp(['   Tumor cell doubling time: ',num2str(DoubTime*6),' hour(s)']);
disp( '|___________________________________________________|');
disp( ' ');
disp( ' ');



fname=['Ex1_',num2str(DoubTime*6),'h'];
print('-djpeg100',fname)

%fname=['tumG_',num2str(DoubTime*6),'h.txt'];
%tumTosave=tumor(1:Ntumor,1:3);
%save(fname,'tumTosave','-ASCII')


disp(' ');
disp('The End!');
disp(' ');
clear all

end



%%%%%%%%%%%%%%%%%%%%%%
function outVal=DefineDoublingTime
  cond=1;
  while (cond>0)
    dt=input('choose doubling time between 6 and 36 hours: ');
    if ((dt>=6)&&(dt<=36)) cond=0; end
  end
  outVal=dt/6;
  disp('Thank you!')
  disp(' ')
end

%%%%%%%%%%%%%%%%%%%%%%
function DrawTumorAge(TumVect,TumNum,DomNum,iter,iterNum)

  FntSz=11;
  
  if (iter==0)
    scrz=get(0,'ScreenSize');  
    figure('Position',[10,scrz(4)/3,2*scrz(3)/3,2*scrz(4)/3])
  end
  
  % plot of the tumor cluster with color-coded cell age
  p1=subplot('position',[0.0,0.15,0.6,0.7]);
  axis([0,DomNum+1,0,DomNum+1])
  hold on
  axis equal
  axis([0,DomNum+1,0,DomNum+1])
  fill([0,DomNum+1,DomNum+1,0,0],[0,0,DomNum+1,DomNum+1,0],'w')
    
  Acol=['g','b','r','y','m','c','k'];
  Anum=7;
  stepAge=10;
  
  tumAge=TumVect(1:TumNum,3);
  tumAge=min(ceil(tumAge/stepAge),Anum);
  for kk=1:Anum
    Ind=find(tumAge==kk);
    sInd=size(Ind,1);
    plot(TumVect(Ind(1:sInd),1),TumVect(Ind(1:sInd),2),'o',...
      'MarkerEdgeColor',Acol(kk),'MarkerFaceColor',Acol(kk)) 
    hold on
  end
  
  text(3,10,'age: ','fontSize',FntSz)
  Axpos=[5,30,55,80,105,130,155,180];
  for ii=1:Anum
    plot(Axpos(ii),5,'ko','MarkerFaceColor',Acol(ii),'MarkerSize',7)  
    hold on
    col_text=[num2str(1+(ii-1)*Anum*6),'~',num2str(ii*Anum*6)];
    text(Axpos(ii)+3,5,col_text);
    hold on
  end
  title(['growing tumor cluster with color-coded cell ages; time: ',...
      num2str(iter*6),' h'],'fontSize',FntSz)  
  
  
  % plot of tumor cluster diameter over time
  p2=subplot('position',[0.6,0.7,0.35,0.2]);
  dist=0;
  for l1=1:TumNum
    distY=max(sqrt((TumVect(1:TumNum,1)-TumVect(l1,1)).^2+...
    (TumVect(1:TumNum,2)-TumVect(l1,2)).^2));  
    dist=max(dist,distY);
  end
    
  grid
  axis([0,6*iterNum+50,0,10*dist+25])
  plot(6*iter,10*dist,'bs','MarkerFaceColor','b')
  grid
  xlabel('time [h]','FontSize',FntSz)
  %ylabel('cluster diameter [\mu m]','FontSize',FntSz)
  title(['tumor cluster diameter (max):  ',num2str(10*dist),'\mu m'],'FontSize',FntSz)
  hold on
  
  
  % plot of the number of tumor cells of different ages
  p3=subplot('position',[0.6,0.1,0.35,0.45]);
  grid
  axis([0,6*iterNum+50,0,TumNum+15])
  plot(6*iter,TumNum,'d','MarkerEdgeColor',[0.5,0.5,0.5],'MarkerFaceColor',...
      [0.5,0.5,0.5],'MarkerSize',7)
  for kk=1:Anum
    Ind=find(tumAge==kk);
    sInd=size(Ind,1);
    plot(6*iter,sInd,'d','MarkerEdgeColor',Acol(kk),'MarkerFaceColor',Acol(kk)) 
    hold on
  end
  grid
  xlabel('time [h]','FontSize',FntSz)
  %ylabel('number of cells','FontSize',FntSz)
  title(['total number of cells (grey): ',num2str(TumNum)],'FontSize',FntSz)
  hold on
  
  pause(0.1)
  
        
end

%%%%%%%%%%%%%%%%%%%%%%
